/**
 * Title:        RandomPlayer1
 * Description:  Remote player that illustrates how to connect to the hex server
 * Copyright:    Copyright (c) 2001
 * Company:      University of Newcastle
 * @author Nathan Lovell
 * @version 1.0
 */

import java.io.*;
import java.net.*;
import hex_c.*;

public abstract class Player {

    public abstract Signal Communicate(Signal s);
    
    public static void main(String[] args)
	throws UnknownHostException, IOException {

	String             host = args[0];
	int                port = Integer.parseInt(args[1]);
	PlayerRandom       player =
	    new PlayerRandom("Random Hex Player");
	Socket             socket =
	    new Socket(host, port);
	OutputStreamWriter socketWriter =
	    new OutputStreamWriter(socket.getOutputStream());
	InputStreamReader  socketReader =
	    new InputStreamReader(socket.getInputStream());

	Signal s;
	while (true) {
	    s = new Signal((char)socketReader.read(),
			   (char)socketReader.read());
	    if (s.signaltype == Signal.FINISH) {
		Signal finish = new Signal('O', 'K');
		socketWriter.write(finish.s1);
		socketWriter.write(finish.s2);
		socketWriter.flush();
		System.exit(0);
	    }

	    s = player.Communicate(s);

	    socketWriter.write(s.s1);
	    socketWriter.write(s.s2);
	    socketWriter.flush();
	}
    }
}

