import hex_c.*;

/**
 * PlayerRandom class that illustrates how to connect to the hex server
 * @author	 Nicolas M. Thiry <nthiery@users.sf.net>
 * @version 1.0
 **/
public class PlayerRandom extends Player
{
    String name;
    java.util.Random randomGenerator;
    boolean[][] used;
    int size;

    public PlayerRandom(String s)
    {
	name = s;
	randomGenerator = new java.util.Random();
    }

    public Signal Communicate(Signal s) {
	System.out.println("Received: " + s.s1+"|"+ s.s2+"|"+ (int)s.s2+"|"+(65+(int)s.s2));
	if (s.s1 == 'R' || s.s1 == 'r') {
	    size = s.s2;
	    used = new boolean[size][];
	    for(int i=0; i<size; i++) {
		used[i] = new boolean[size];
		for(int j=0; j<size; j++) {
		    used[i][j] = false;
		}
	    }
	    return new Signal('O', 'k');
	}
	if (s.s1 == 'W' || s.s1 == 'w' || s.s1 == 'L' || s.s1 == 'l') {
	    return new Signal('O', 'k');
	}
	if (s.s2 < 12) {
	    used[s.s1-65][s.s2-1] = true;
	}
	int i;
	int j;
	do {
	    i = randomGenerator.nextInt(size);
	    j = randomGenerator.nextInt(size);
	} while (used[i][j]);
	used[i][j] = true;
	System.out.println("Sent "+i+" "+j);
	return new Signal((char)(65+i),(char)(j+1));
    }
}
