package hex_c;

// class Signal - used for sending instructions between referee and player
public class Signal {

  public static final int RESET = 0;
  public static final int OK = 1;
  public static final int OPENING = 2;
  public static final int SWAP = 3;
  public static final int MOVE = 4;
  public static final int WIN = 5;
  public static final int LOSS = 6;
  public static final int QUIT = 7;
  public static final int FINISH = 8;
  public static final int ERROR = 9;

  public char s1; // Signal 1 - indicates reset, ok, opening, move(row), win, loss or quit
  public char s2; // Signal 2 - indicates move(column) or boardsize with reset

  public int signaltype; // Type of signal

  public Signal(char sig1, char sig2) {
    s1 = sig1;
    s2 = sig2;
    if ((s1 == 'R' || s1 == 'r') && (s2 > 0))    // s2 contains the boardsize of new game
      signaltype = RESET;
    else if ((s1 == 'O' || s1 == 'o') && (s2 == 'K' || s2 == 'k'))
      signaltype = OK;
    else if (s1 == 'O' || s1 == 'o')
      signaltype = OPENING;
    else if ((s1 == 'S' || s1 == 's') && (s2 == 'W' || s2 == 'w'))
      signaltype = SWAP;
    else if (((s1 >= 'A' && s1 <= 'N') || (s1 >= 'a' && s1 <= 'n')) && ((int)s2 > 0 && (int)s2 < 12))
      signaltype = MOVE;
    else if (s1 == 'W' || s1 == 'w')
      signaltype = WIN;
    else if (s1 == 'L' || s1 == 'l')
      signaltype = LOSS;
    else if (s1 == 'Q' || s1 == 'q')
      signaltype = QUIT;
    else if ((s1 == 'F' || s1 == 'f') && (s2 == 'I' || s2 == 'i'))
      signaltype = FINISH;
    else if (s1 == 'E' || s1 == 'e')
      signaltype = ERROR;
  }

} // end Signal

