/**
 * an application which demonstrates the reference effect in java
 *
 * @version	$Id: ReferencesDemo.java,v 1.1 2002/11/05 12:14:03 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

public class ReferencesDemo {

    public static void testRef1(Counter c) {
	// In this subprocedure, we call a method of the object c
	System.out.println("testRef1: " + c.get());
	c.increase();
	System.out.println("testRef1: " + c.get());
    }
    
    public static void testRef2(Counter c) {
	// In this subprocedure, we modify c itself
	System.out.println("testRef2: " + c.get());
	c=new Counter();
	System.out.println("testRef2: " + c.get());
    }
    
    public static void main (String[] args) {
	Counter c=new Counter();
	System.out.println("main: " + c.get());

	// We demonstrate the effect of the increase method:
	c.increase();
	System.out.println("main: " + c.get());

	// We pass c to the subprocedure testRef1 and look if it is modified
	testRef1(c);
	System.out.println("main: " + c.get());

	// We pass c to the subprocedure testRef2 and look if it is modified
	testRef2(c);
	System.out.println("main: " + c.get());
    }
}
