/**
 * an application for a two players queens game
 *
 * @version	$Id: TwoPlayersQueens.java,v 1.2 2002/11/05 23:05:11 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

public class TwoPlayersQueens {

    public static void main(String [] args) {

	// Initialization
	HumanPlayer player1 = new HumanPlayer(1);
	HumanPlayer player2 = new HumanPlayer(-1);
	Board board = new Board();

	// Game: each player plays in turn
	board.print();
	while (!board.isFinished()) {
	    Move move=player1.nextMove(board);
	    board.move(move);
	    board.print();
	    if (board.isFinished()) { break; };

	    move=player2.nextMove(board);
	    board.move(move);
	    board.print();
	}

	// End of game, print out who is the winner
	switch (board.winner()) {
	case 1:
	    System.out.println("White wins"); break;
	case -1:
	    System.out.println("Black wins"); break;
	case 0:
	    System.out.println("Game is a draw"); break;
	}

    }
}
