/**
 * Test suite for the Sort class
 *
 * @version	$Id: SortTest.java,v 1.1.2.1 2003/10/01 12:38:44 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

import java.util.ArrayList;

public class SortTest {
    public static void main(String[] args) {
	int [][] data = {
	    {},
	    { 1 },
	    { 2, 1 },
	    { 1, 2 },
	    { 5, 2, 3, 4, 5, 5, 3, 1, 9, 2 }
	};
	int [] [] results = {
	    {},
	    { 1 },
	    { 1, 2 },
	    { 1, 2 },
	    { 1, 2, 2, 3, 3, 4, 5, 5, 5, 9 }
	};
	for (int i=0; i < data.length; i++) {
	    int[] result = Sort.selectionSort(data[i]);
	    if (!ArrayUtils.equal(results[i], result)) {
		System.out.println("FAIL " + i);
		System.out.println("Expected: "
				   + ArrayUtils.toString(results[i]));
		System.out.println("Got:      "
				   + ArrayUtils.toString(result));
	    }
	}
    }
}
