/**
 * A library with miscellaneous utilities for arrays of integers
 *
 * @version	$Id: ArrayUtils.java,v 1.1 2003/09/30 20:29:16 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

public class ArrayUtils {

    /**
     * Convert anArray into a string
     *
     * @param anArray	an array of integers
     * @return		a string representing anArray
     **/
    public static String toString(int[] anArray) {
	String result = "";
	if (anArray.length == 0) {
	    return result;
	}
	result = result + anArray[0];
	for (int i=1; i < anArray.length; i++) {
	    result = result + " " + anArray[i];
	}
	return result;
    }
    
    /**
     * Test whether anArray1 and anArray2 are equal (same length; same contents)
     *
     * @param anArray1	an array of integers
     * @param anArray2	an array of integers
     * @return		a boolean
     **/
    public static boolean equal(int[] anArray1, int[] anArray2) {
	if (anArray1.length != anArray2.length) {
	    return false;
	}
	for (int i=0; i<anArray1.length; i++) {
	    if (anArray1[i] != anArray2[i]) {
		return false;
	    }
	}
	return true;
    }
}
