/**
 * testsuite for the Statistics class
 *
 * @version	$Id: StatisticsTest.java,v 1.1 2003/10/07 10:06:55 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

import java.util.ArrayList;

public class StatisticsTest {

    /**
     * Utility to build an ArrayList of Double from an array of double
     **/
    static ArrayList makeArrayOfDoubles(double[] anArray) {
	ArrayList result = new ArrayList();
	for (int i=0; i<anArray.length; i++) {
	    result.add(new Double(anArray[i]));
	}
	return result;
    }
    
    public static void main(String[] args) {
	int testId;

	double[][] numericalSeries =
	    {
		{ },
		{ 5 },
		{ 1, 2 },
		{ 1, 5, 3, 2, 1 },
	    };

	double[] means =
	    {
		0,
		5,
		1.5,
		1.2
	    };

	////////////////////////////////////////////////////////////////////////
	// Tests for Statistics.mean
	////////////////////////////////////////////////////////////////////////

	testId = 1;
	for (int i = 0; i<numericalSeries.length; i++) {
	    ArrayList l = makeArrayOfDoubles(numericalSeries[i]);
	    Number mean = new Double(means[i]);
	    if (!Statistics.mean(l).equals(mean)) {
		System.out.println("FAIL " + testId);
	    }
	    testId++;
	}
    }
}
