/**
 * Test suite for the Stack class
 *
 * @version	$Id: BinaryTreeTest.java,v 1.1.2.1 2003/10/30 00:03:32 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

public class BinaryTreeTest {

    static int testId = 0;
    
    public static void test(Object a, Object b) {
	testId++;
	if (!a.equals(b)) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void test(boolean b) {
	testId++;
	if (!b) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void testfunc(String s) {
	testId = 0;
	System.out.println("Testing "+s);
    }
    
    public static void main(String[] args) {
	BinaryTree [] trees = {
	    new BinaryTree("root"),
	    new BinaryTree("root",
			   new BinaryTree("left"),
			   new BinaryTree("right")),
	    new BinaryTree("root",
			   new BinaryTree("l",
					  new BinaryTree("ll"),
					  new BinaryTree("lr")),
			   new BinaryTree("r",
					  new BinaryTree("rl"),
					  new BinaryTree("rr")))
	};
	testfunc("size");
	int [] sizes = { 1, 3, 7 };
	for (int i=0;i<trees.length;i++) {
	    test(trees[i].size()==sizes[i]);
	}

	testfunc("toArrayInfix");
	Object[][] infix = {
	    { "root" },
	    { "left", "root", "right" },
	    { "ll", "l", "lr", "root", "rl", "r", "rr" }
	};
	for (int i=0;i<trees.length;i++) {
	    test(ArrayUtils.equal(trees[i].toArrayInfix(),infix[i]));
	}

	testfunc("toArrayPrefix");
	Object[][] prefix = {
	    { "root" },
	    { "root", "left", "right" },
	    { "root", "l", "ll", "lr", "r", "rl", "rr" }
	};
	for (int i=0;i<trees.length;i++) {
	    test(ArrayUtils.equal(trees[i].toArrayPrefix(),prefix[i]));
	}

	testfunc("toArrayPostfix");
	Object[][] postfix = {
	    { "root" },
	    { "left", "right", "root" },
	    { "ll", "lr", "l", "rl", "rr", "r", "root"}
	};
	for (int i=0;i<trees.length;i++) {
	    test(ArrayUtils.equal(trees[i].toArrayPostfix(),postfix[i]));
	}

	testfunc("toArrayBreathFirst");
	Object[][] breathFirst = {
	    { "root" },
	    { "root", "left", "right" },
	    { "root", "l", "r", "ll", "lr", "rl", "rr" }
	};
	for (int i=0;i<trees.length;i++) {
	    test(ArrayUtils.equal(trees[i].toArrayBreathFirst(),breathFirst[i]));
	}
    }
}
