/**
 * A class for stacks
 *
 * @version $Id: Stack.java,v 1.1.2.1 2003/10/08 21:24:32 nthiery Exp $
 * @author  Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

public class Stack {

    /**
     * A class for the cells of the Stack. Each cell stores a value,
     * and a reference to the previous cell of the stack.
     **/
    class Cell {
	Object value;
	Cell   previous;

	Cell(Object v, Cell p) {
	    value    = v;
	    previous = p;
	}
    }

    Cell peak;

    /**
     * Empty stack Constructor
     **/
    public Stack() {
	peak = null;
    }

    /**
     * Tests if this stack is empty
     *
     * @return true if this stack has no elements; false otherwise.
     **/
    public boolean isEmpty () {
	return(peak == null);
    }

    /**
     * Pop the top value of the stack
     *
     * @throws java.util.EmptyStackException if the stack is empty
     * @return the popped value
     **/
    public Object pop () {
	if (peak == null) {
	    throw new java.util.EmptyStackException();
	}
	Object value = peak.value;
	peak         = peak.previous;
	return value;
    }

    /**
     * Push a value on top of the stack
     *
     * @param value	an object to be pushed on top of the stack
     **/
    public void push (Object value) {
	peak = new Cell(value, peak);
    }
}
