/**
 * Test suite for the ExpressionTree class
 *
 * @version	$Id: ExpressionTreeTest.java,v 1.1 2003/10/08 21:21:25 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

public class ExpressionTreeTest {

    static int testId = 0;
    
    public static void test(Object a, Object b) {
	testId++;
	if (!a.equals(b)) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void test(boolean b) {
	testId++;
	if (!b) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void main(String[] args) {

	// 5*2 + (3+8)*7
	ExpressionTree tree =
	    new ExpressionTree
	    ("+",
	     new ExpressionTree
	     ("*",
	      new ExpressionTree(5),
	      new ExpressionTree(2)),
	     new ExpressionTree
	     ("*",
	      new ExpressionTree
	      ("+",
	       new ExpressionTree(3),
	       new ExpressionTree(8)),
	      new ExpressionTree(7)));

	test(ExpressionTree.evaluate(), 87);
	test(ExpressionTree.infix(), new String("5*2 + (3+8)*7"));
	test(ExpressionTree.prefix(), new String("+ * 5 2 * + 3 8 7"));
	test(ExpressionTree.infix(), new String("5 2 * 3 8 + 7 * +"));
    }
}
