/**
 * Test suite for the Stack class
 *
 * @version	$Id: StackTest.java,v 1.1 2003/10/08 21:21:25 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

public class StackTest {

    static int testId = 0;
    
    public static void test(Object a, Object b) {
	testId++;
	if (!a.equals(b)) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void test(boolean b) {
	testId++;
	if (!b) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void main(String[] args) {
	Stack stack = new Stack();

	test(stack.isEmpty());
	stack.push(new Integer(1));
	test(!stack.isEmpty());
	stack.push(new Integer(2));
	stack.push(new Integer(3));
	stack.push(new Integer(4));
	test(stack.pop(), new Integer(4));
	test(stack.pop(), new Integer(3));
	test(stack.pop(), new Integer(2));
	stack.push(new Integer(5));
	test(stack.pop(), new Integer(5));
	test(stack.pop(), new Integer(1));
	test(stack.isEmpty());
	try {
	    stack.pop();
	    test(false);
	} catch(java.util.EmptyStackException x) {
	    test(true);
	} catch(Exception x) {
	    test(false);
	}
    }
}
