/**
 * testsuite for the Polynom class
 *
 * @version	$Id: PolynomTest.java,v 1.1.2.1 2003/10/31 22:16:25 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

import java.util.ArrayList;

public class PolynomTest {

    static int testId = 0;
    
    public static void test(Object a, Object b) {
	testId++;
	if (!a.equals(b)) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void test(boolean b) {
	testId++;
	if (!b) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void testfunc(String s) {
	testId = 0;
	System.out.println("Testing "+s);
    }
    
    public static void main(String[] args) {
	int testId;

	Polynom p = new Polynom();
	test(p.isZero());
	test(p.getDegree()==-1);
	test(p.toString(), new String("0"));
	test(p.equals(p));
	test(p.equals(new Polynom(p.toString())));
	test(p.evaluate(0)==0);
	test(p.evaluate(5)==0);
	p.setCoeff(3,1);
	test(p.equals(new Polynom("1x^3")));

	testfunc("method toString");
	test(new Polynom("-3x^1"    ).toString(), new String("-3x^1"));
	test(new Polynom("1x^1"     ).toString(), new String("x^1"));
	test(new Polynom("x^1"      ).toString(), new String("x^1"));
	test(new Polynom("2x^0-3x^1").toString(), new String("2x^0-3x^1"));
	test(new Polynom("2x^0-x^1").toString(), new String("2x^0-x^1"));
	test(new Polynom("2x^0+x^1").toString(), new String("2x^0+x^1"));

	p = new Polynom("3x^4+2x^3");
	test(!p.isZero());
	test(p.getDegree()==4);
	test(p.toString(), new String("2x^3+3x^4"));
	test(p.clone().toString(), new String("2x^3+3x^4"));
	test(p.equals(new Polynom(p.toString())));

	testfunc("method evaluate");
	test(p.evaluate(0)==0);
	test(p.evaluate(1)==5);
	test(p.evaluate(2)==64);
	test(p.evaluate(3)==297);
	test(p.evaluate(4)==896);

	testfunc("method add");
	p=p.add(new Polynom("2x^1-3x^4"));
	test(p.equals(new Polynom("2x^1+2x^3")));
	p=p.add(new Polynom("-2x^4"));
	test(p.equals(new Polynom("2x^1+2x^3-2x^4")));
	p=p.add(new Polynom("-2x^1"));
	test(p.equals(new Polynom("2x^3-2x^4")));
	p=p.add(new Polynom("-2x^3"));
	test(p.equals(new Polynom("-2x^4")));
	p=p.add(new Polynom("2x^4"));
	test(p.isZero());
	test(p.equals(new Polynom("0")));
	p=p.add(new Polynom("2x^4"));
	test(p.equals(new Polynom("2x^4")));

	String [] [] data = {
	    { "x^2",		"x^4",		"x^6"		},
	    { "x^1",		"x^1",		"x^2"		},
	    { "x^1",		"x^4",		"x^5"		},
	    { "x^2",		"x^2",		"x^4"		},
	    { "x^3",		"x^3",		"x^6"		},
	    { "x^0",		"2x^3+x^17",	"2x^3+x^17"	},
	    { "2x^3+x^17",	"x^0",		"2x^3+x^17"	},
	    { "3x^2",		"2x^3",		"6x^5"		},
	    { "x^2",		"2x^3+x^17",	"2x^5+x^19"	},
	    { "3x^1+17x^15",	"-2x^3+x^12+2x^0",
	      		"6x^1-6x^4+3x^13+34x^15-34x^18+17x^27"	}
	};

	testfunc("method multiply");
	for (int i=0; i<data.length; i++) {
	    test(new Polynom(data[i][0]).multiply(new Polynom(data[i][1]))
	     .equals(new Polynom(data[i][2])));
	}
	testfunc("method multiplyKaratsuba");
	for (int i=0; i<data.length; i++) {
	    p = new Polynom(data[i][0]).multiplyKaratsuba(new Polynom(data[i][1]));
	    // System.out.println("p: "+p);
	    test(p.equals(new Polynom(data[i][2])));
	}
    }
}
