/**
 * An application for decrypting with RSA
 *
 * usage: java RSADecrypt n key
 *  - read from the standard input a list of big integers, one per line
 *    lines starting with a '#' are ignored
 *  - write to the standard output the corresponding decrypted message
 *
 * @version	$Id: RSADecrypt.java,v 1.2.2.1 2003/11/26 10:53:18 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

import java.math.BigInteger;
import java.util.LinkedList;
import java.io.*;

public class RSADecrypt {
    public static void main(String[] args) throws java.io.IOException {
	BigInteger n = new BigInteger(args[0]);
	BigInteger key = new BigInteger(args[1]);

	LinkedList messageEncrypted=new LinkedList();
	BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
	String line;
	while( (line=in.readLine())!=null ) {
	    if (line.charAt(0) == '#') continue;
	    messageEncrypted.add(new BigInteger(line));
	}
	System.out.println(RSA.decode(RSA.rsa(messageEncrypted, n, key), n));
    }
}
