/**
 * testsuite for the RSA class
 *
 * @version	$Id: RSATest.java,v 1.2.2.1 2003/11/26 10:53:21 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

import java.math.BigInteger;
import java.util.List;
import java.util.ArrayList;

public class RSATest {

    static int testId = 0;
    
    public static void test(Object a, Object b) {
	testId++;
	if (!a.equals(b)) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void test(boolean b) {
	testId++;
	if (!b) {
	    System.out.println("FAIL " + testId);
	}
    }

    public static void testfunc(String s) {
	testId = 0;
	System.out.println("Testing "+s);
    }
    
    public static List makeBigIntegerList(int[] array) {
	ArrayList result = new ArrayList(array.length);
	for (int i=0; i<array.length; i++) {
	    result.add(BigInteger.valueOf(array[i]));
	}
	return result;
    }
    
    public static void main(String[] args) {
	int[] digits = { 0, 1, 0, 1 };
	testfunc("fromBase");
	test(RSA.fromBase(makeBigIntegerList(digits), BigInteger.valueOf(2)),
	     BigInteger.valueOf(10));
	test(RSA.fromBase(makeBigIntegerList(digits), BigInteger.valueOf(10)),
	     BigInteger.valueOf(1010));

	testfunc("toBase");
	for (int i=0; i<1000; i++) {
	    test(RSA.fromBase(RSA.toBase(BigInteger.valueOf(i),
					 BigInteger.valueOf(7)),
			      BigInteger.valueOf(7)),
		 BigInteger.valueOf(i));
	}

	testfunc("encode");
	int [] digits2 = { 17966, 67 };
	test(RSA.encode("ABC", BigInteger.valueOf(65521)),
	     makeBigIntegerList(digits2));

	testfunc("decode");
	test(RSA.decode(makeBigIntegerList(digits2), BigInteger.valueOf(65521)),
	     "ABC");
    }
}
