/**
 * A class for RSA cryptography
 *
 * @version	$Id: RSA.java,v 1.4 2003/11/26 01:29:27 nthiery Exp $
 * @author	Nicolas M. Thiry <nthiery@users.sourceforge.net>
**/

import java.math.BigInteger;
import java.util.List;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ArrayList;
import gnu.regexp.*;

class RSA {

    /**
     * Returns a big integer from its list of digits in base radix
     *
     * For example, [0,1,0,0,1] in base 2 denotes the integer 18
     *
     * @param digits	a List of non-negative BigInteger: the list of digits.
     * @param radix	a non-negative BigInteger: the radix
     *
     * @return		the non-negative BigInteger whose digits are digits in base radix
     **/
    public static BigInteger fromBase(List digits, BigInteger radix) {
	// ...
	return new BigInteger("0");
    }

    /**
     * Returns the list of the digits of a big integer in base radix
     *
     * For example, the integer 18 is written as [0,1,0,0,1] in base 2
     *
     * @param n		a non-negative BigInteger
     * @param radix	a non-negative BigInteger: the radix
     *
     * @return		the list of digits of n in base radix, as a List of BigInteger
     **/
    public static List toBase(BigInteger n, BigInteger radix) {
	// ...
	return(new ArrayList());
    }

    /**
     * Encodes an ASCII string as a list of BigInteger's < radix
     *
     * By using the standard ASCII code, each character of the string
     * is considered as an integer between 0 and 255. Then, the whole
     * string is considered as a (big) non-negative integer written in
     * base 256, which is returned as a list of digits in base radix.
     *
     * Example: "ABC" is considered as the number 4373570 = 65 + 66*255 + 67*255^2.
     * Expressed in base radix=65521, the result would be the
     * collection [49184, 66], because 4373570 = 49184 + 66*65521
     *
     * @param string	a string
     * @param radix	a non-negative BigInteger: the radix
     * @return		a List of BigInteger's
     **/
    public static List encode(String string, BigInteger radix) {
	// ...
	return(new ArrayList());
    }

    /**
     * Decodes an ASCII string from a list of BigInteger's < radix
     *
     * See encode for the description of the encoding
     *
     * @param string	a collection of non-negative BigInteger's less than radix
     * @param radix	a non-negative BigInteger: the radix
     * @return		a string
     **/
    public static String decode(List digits, BigInteger n) {
	// ...
	return(new String());
    }

    /**
     * Returns a copy of the collection after application of the RSA
     * algorithm with key (n,key) to each BigInteger in the List
     *
     * @param digits	a collection of non-negative BigInteger's < n
     * @param n		a non-negative BigInteger
     * @param key	a non-negative BigInteger
     * @return		a collection of non-negative BigInteger's < n
     **/
    public static List rsa(List digits, BigInteger n, BigInteger key) {
	// ....
	return(new ArrayList());
    }

    /**
     * Inverse of a big integer modulo m
     *
     * @param n		a BigInteger
     * @param exponent  a BigInteger
     * @param m		a BigInteger
     * @return		a BigInteger: n^power mod m
     * @throws		ArithmeticException if m <= 0, or n has no multiplicative inverse mod m (that is, this BigInteger is not relatively prime to m).
    **/
    public BigInteger modInverse(BigInteger n, BigInteger power, BigInteger modulo) {
	// ...
	return new BigInteger("0");
    }

    /**
     * Power of a big integer modulo m
     *
     * @param n		a BigInteger
     * @param exponent  a BigInteger
     * @param m		a BigInteger
     * @return		a BigInteger: n^power mod m
    **/

    public BigInteger modPow(BigInteger n, BigInteger power, BigInteger modulo) {
	// ...
	return new BigInteger("0");
    }

}
